/**
 * Simple WYSIWYG editor for Bootstrap3
 *
 * @category        jQuery Plugin
 * @version         1.1.3
 * @author          Alexsander Vyshnyvetskyy <alex.vyshnyvetskyy@gmail.com>
 * @link            http://wdmg.github.io/bootstrap-wysiwyg
 * @copyright       Copyright (c) 2019 - 2020 W.D.M.Group, Ukraine
 * @license         https://opensource.org/licenses/MIT Massachusetts Institute of Technology (MIT) License
 *
 */
!function(e){"use strict";var t=function(){function e(e,t){for(var a in t){var o=t[a];o.configurable=!0,o.value&&(o.writable=!0)}Object.defineProperties(e,t)}return function(t,a,o){return a&&e(t.prototype,a),o&&e(t,o),t}}(),a=function(e){var o=e.fn.wysiwyg,n={toolbar:[["mode"],["operations",["undo","rendo","cut","copy","paste"]],["styles"],["fonts",["select","size"]],["text",["bold","italic","underline","strike","subscript","superscript","font-color","bg-color"]],["align",["left","center","right","justify"]],["lists",["unordered","ordered","indent","outdent"]],["components",["table"]],["intervals",["line-height","letter-spacing"]],["insert",["emoji","link","image","video","symbol"]],["special",["print","unformat","visual","clean"]]],fontSizes:["8px","9px","10px","11px","12px","14px","15px","16px","18px","20px","24px","30px","32px","36px","48px"],fontSizeDefault:"12px",fontFamilies:["Open Sans","Arial","Arial Black","Courier","Courier New","Comic Sans MS","Helvetica","Impact","Lucida Grande","Lucida Sans","Tahoma","Times","Times New Roman","Verdana"],fontFamilyDefault:"Open Sans",emojiDefault:["😀","😬","😁","😂","😃","😄","😅","😆","😇","😉","😊","🙂","🙃","😋","😌","😍","😘","😗","😙","😚","😜","😝","😛","🤑","🤓","😎","🤗","😏","😶","😐","😑","😒","🙄","🤔","😳","😞","😟","😠","😡","😔","😕","🙁","😣","😖","😫","😩","😤","😮","😱","😨","😰","😯","😦","😧","😢","😥","😪","😓","😭","😵","😲","🤐","😷","🤒","🤕","😴","💤"],symbolsDefault:["&lt;","&gt;","&laquo;","&raquo;","&lsaquo;","&rsaquo;","&quot;","&prime;","&Prime;","&lsquo;","&rsquo;","&sbquo;","&ldquo;","&rdquo;","&bdquo;","&#10076;","&#10075;","&amp;","&apos;","&sect;","&copy;","&not;","&reg;","&macr;","&deg;","&plusmn;","&sup1;","&sup2;","&sup3;","&frac14;","&frac12;","&frac34;","&acute;","&micro;","&para;","&middot;","&iquest;","&fnof;","&trade;","&bull;","&hellip;","&oline;","&ndash;","&mdash;","&permil;","&#125;","&#123;","&#61;","&ne;","&cong;","&asymp;","&le;","&ge;","&ang;","&perp;","&radic;","&sum;","&int;","&#8251;","&divide;","&infin;","&#64;","&#91;","&#93;","&larr;","&uarr;","&rarr;","&darr;","&harr;","&crarr;","&lArr;","&uArr;","&rArr;","&dArr;","&hArr;","&#10144;","&#10148;","&#10149;","&#10150;","&#10163;","&#8634;","&#8635;","&#8679;","&#8617;","&#11015;","&#11014;","&spades;","&clubs;","&hearts;","&diams;","&#9825;","&#9826;","&#9828;","&#9831;","&#8372;","&euro;","&dollar;","&cent;","&pound;","&#8381;","&yen;","&#8377;","&#22291;","&#8376;"],colorPalette:[["rgb(0, 0, 0)","rgb(67, 67, 67)","rgb(102, 102, 102)","rgb(153, 153, 153)","rgb(183, 183, 183)","rgb(204, 204, 204)","rgb(217, 217, 217)","rgb(239, 239, 239)","rgb(243, 243, 243)","rgb(255, 255, 255)"],["rgb(152, 0, 0)","rgb(255, 0, 0)","rgb(255, 153, 0)","rgb(255, 255, 0)","rgb(0, 255, 0)","rgb(0, 255, 255)","rgb(74, 134, 232)","rgb(0, 0, 255)","rgb(153, 0, 255)","rgb(255, 0, 255)"],["rgb(230, 184, 175)","rgb(244, 204, 204)","rgb(252, 229, 205)","rgb(255, 242, 204)","rgb(217, 234, 211)","rgb(208, 224, 227)","rgb(201, 218, 248)","rgb(207, 226, 243)","rgb(217, 210, 233)","rgb(234, 209, 220)","rgb(221, 126, 107)","rgb(234, 153, 153)","rgb(249, 203, 156)","rgb(255, 229, 153)","rgb(182, 215, 168)","rgb(162, 196, 201)","rgb(164, 194, 244)","rgb(159, 197, 232)","rgb(180, 167, 214)","rgb(213, 166, 189)","rgb(204, 65, 37)","rgb(224, 102, 102)","rgb(246, 178, 107)","rgb(255, 217, 102)","rgb(147, 196, 125)","rgb(118, 165, 175)","rgb(109, 158, 235)","rgb(111, 168, 220)","rgb(142, 124, 195)","rgb(194, 123, 160)","rgb(166, 28, 0)","rgb(204, 0, 0)","rgb(230, 145, 56)","rgb(241, 194, 50)","rgb(106, 168, 79)","rgb(69, 129, 142)","rgb(60, 120, 216)","rgb(61, 133, 198)","rgb(103, 78, 167)","rgb(166, 77, 121)","rgb(133, 32, 12)","rgb(153, 0, 0)","rgb(180, 95, 6)","rgb(191, 144, 0)","rgb(56, 118, 29)","rgb(19, 79, 92)","rgb(17, 85, 204)","rgb(11, 83, 148)","rgb(53, 28, 117)","rgb(116, 27, 71)","rgb(91, 15, 0)","rgb(102, 0, 0)","rgb(120, 63, 4)","rgb(127, 96, 0)","rgb(39, 78, 19)","rgb(12, 52, 61)","rgb(28, 69, 135)","rgb(7, 55, 99)","rgb(32, 18, 77)","rgb(76, 17, 48)"]],mode:"editor",language:"en-us",translations:{},highlight:!0,debug:!1};const l={"Header H1":{action:"formatblock",value:"h1",wrap:"<h1 />"},"Header H2":{action:"formatblock",value:"h2",wrap:"<h2 />"},"Header H3":{action:"formatblock",value:"h3",wrap:"<h3 />"},"Header H4":{action:"formatblock",value:"h4",wrap:"<h4 />"},"Header H5":{action:"formatblock",value:"h5",wrap:"<h5 />"},"Header H6":{action:"formatblock",value:"h6",wrap:"<h6 />"},Paragraph:{action:"formatblock",value:"p",wrap:"<p />"},Blockquote:{action:"formatblock",value:"blockquote",wrap:"<blockquote />"},Preformatted:{action:"formatblock",value:"pre",wrap:"<pre />"},"Div block":{action:"formatblock",value:"div",wrap:"<div />"}},r={youtube:"YouTube",vimeo:"Vimeo",dailymotion:"Dailymotion",source:"Source media"},i={https:"https://",http:"http://",mailto:"mailto://",ftp:"ftp://",feed:"feed://",news:"news://",tel:"tel:",skype:"skype:",telegram:"tg://",whatsapp:"whatsapp:",viber:"viber:",other:"other"},s={blank:"New tab",top:"Main tab",self:"Current tab",parent:"Parent tab"},d={nofollow:"Do not follow (for robots)",noreferrer:"Do not pass HTTP-referrer"};var c=function(){function o(t,a){var r=this;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(r,o),r._config=e.extend({},n,a),r._config.debug&&console.log("Init WYSIWYG editor..."),r._editorId="wysiwyg-"+(String.fromCharCode(Math.floor(11*Math.random()))+Math.floor(1e6*Math.random())).trim(),r._$element=t instanceof jQuery?t:e(t),r._inputId=r._$element.attr("id"),r._$editor=e('<div id="'+r._editorId+'" aria-describedby="#'+r._inputId+'" class="wysiwyg-editor" />'),r._$element.wrap(r._$editor),r._$content=e('<div class="editor-content" contenteditable="true" />'),r._$content.html(r._$element.val()),r._$element.before(r._$content),r._source=r._$element.val(),r._selection=document.getSelection(),r._popoverIsVisible=!1,r._$lastFocus=null,r._$toolbar=e('<div class="wysiwyg-toolbar btn-toolbar" />'),r._$content.before(r._$toolbar),r._$statusbar=e('<div class="editor-statusbar" />'),r._$statusbar.stat=e('<span class="editor-statusbar-stat" />'),r._$statusbar.path=e('<span class="editor-statusbar-path" />'),r._$statusbar.append(r._$statusbar.stat),r._$statusbar.append(r._$statusbar.path),r._$content.after(r._$statusbar),r._$element.addClass("hide"),"object"==typeof r._config.toolbar&&e.each(r._config.toolbar,(function(t,a){var o=e('<div id="toolbarGroup-'+a[0]+'" class="btn-group" role="group" />');if("mode"===a[0]){var n=r._buildTollbarButton("mode","editor","fa fa-eye",null,"Editor"),i=r._buildTollbarButton("mode","source","fa fa-code",null,"Source");"editor"==r._config.mode?n.addClass("active"):i.addClass("active"),o.append(n),o.append(i)}else if("operations"===a[0])o.append(r._buildTollbarButton("operations","undo","fa fa-reply",null,"Undo")),o.append(r._buildTollbarButton("operations","rendo","fa fa-share",null,"Rendo")),o.append(r._buildTollbarButton("operations","cut","fa fa-cut",null,"Cut")),o.append(r._buildTollbarButton("operations","copy","fa fa-copy",null,"Copy")),o.append(r._buildTollbarButton("operations","paste","fa fa-clipboard",null,"Paste"));else if("styles"===a[0])o.append(r._buildTollbarDropdown("select-style",l,"Paragraph","Text style"));else if("fonts"===a[0]){if(-1!==a[1].indexOf("select",0)){var s={};e.each(r._config.fontFamilies,(function(e,t){s[t]={action:"fontname",value:t,style:"font-family: "+t+";"}})),o.append(r._buildTollbarDropdown("font-select",s,r._config.fontFamilyDefault,"Font family"))}if(-1!==a[1].indexOf("size",0)){var d={};e.each(r._config.fontSizes,(function(e,t){d[t]={action:"fontsize",value:t}})),o.append(r._buildTollbarDropdown("font-size",d,r._config.fontSizeDefault,"Font size"))}}else"text"===a[0]?(-1!==a[1].indexOf("bold",0)&&o.append(r._buildTollbarButton("text","bold","fa fa-bold",null,"Bold")),-1!==a[1].indexOf("italic",0)&&o.append(r._buildTollbarButton("text","italic","fa fa-italic",null,"Italic")),-1!==a[1].indexOf("underline",0)&&o.append(r._buildTollbarButton("text","underline","fa fa-underline",null,"Underline")),-1!==a[1].indexOf("strike",0)&&o.append(r._buildTollbarButton("text","strike","fa fa-strikethrough",null,"Striked text")),-1!==a[1].indexOf("subscript",0)&&o.append(r._buildTollbarButton("text","subscript","fa fa-subscript",null,"Subscript")),-1!==a[1].indexOf("superscript",0)&&o.append(r._buildTollbarButton("text","superscript","fa fa-superscript",null,"Superscript")),-1!==a[1].indexOf("bg-color",0)&&o.append(r._buildTollbarButton("text","font-color","fa fa-font",null,"Font color",r._buildColorPalette(r._config.colorPalette,"font-color",null))),-1!==a[1].indexOf("bg-color",0)&&o.append(r._buildTollbarButton("text","bg-color","fa fa-paint-brush",null,"Background color",r._buildColorPalette(r._config.colorPalette,"bg-color",!0)))):"align"===a[0]?(-1!==a[1].indexOf("left",0)&&o.append(r._buildTollbarButton("align","left","fa fa-align-left",null,"Align left",null)),-1!==a[1].indexOf("center",0)&&o.append(r._buildTollbarButton("align","center","fa fa-align-center",null,"Align center",null)),-1!==a[1].indexOf("right",0)&&o.append(r._buildTollbarButton("align","right","fa fa-align-right",null,"Align right",null)),-1!==a[1].indexOf("justify",0)&&o.append(r._buildTollbarButton("align","justify","fa fa-align-justify",null,"Justify content",null))):"lists"===a[0]?(-1!==a[1].indexOf("unordered",0)&&o.append(r._buildTollbarButton("lists","unordered","fa fa-list-ul",null,"Unordered list")),-1!==a[1].indexOf("ordered",0)&&o.append(r._buildTollbarButton("lists","ordered","fa fa-list-ol",null,"Ordered list")),-1!==a[1].indexOf("indent",0)&&o.append(r._buildTollbarButton("lists","indent","fa fa-indent",null,"Indent")),-1!==a[1].indexOf("outdent",0)&&o.append(r._buildTollbarButton("lists","outdent","fa fa-outdent",null,"Outdent"))):"components"===a[0]?(-1!==a[1].indexOf("table",0)&&o.append(r._buildTollbarButton("components","table","fa fa-table",null,"Insert table",r._buildTableGrid())),-1!==a[1].indexOf("chart",0)&&o.append(r._buildTollbarButton("components","chart","fa fa-pie-chart",null,"Add chart"))):"intervals"===a[0]?(-1!==a[1].indexOf("line-height",0)&&o.append(r._buildTollbarButton("interval","line-height","fa fa-text-height",null,"Lines interval",r._buildLineHeightList())),-1!==a[1].indexOf("letter-spacing",0)&&o.append(r._buildTollbarButton("interval","letter-spacing","fa fa-text-width",null,"Letter spacing",r._buildLetterSpacingList()))):"insert"===a[0]?(-1!==a[1].indexOf("emoji",0)&&o.append(r._buildTollbarButton("insert","emoji","fa fa-smile fa-smile-o",null,"Add emoji",r._buildEmojiList())),-1!==a[1].indexOf("link",0)&&o.append(r._buildTollbarButton("insert","link","fa fa-link",null,"Add URL",r._buildUrlForm("link"))),-1!==a[1].indexOf("image",0)&&o.append(r._buildTollbarButton("insert","image","fa fa-image",null,"Add image",r._buildUrlForm("image"))),-1!==a[1].indexOf("video",0)&&o.append(r._buildTollbarButton("insert","video","fa fa-video-camera fa-video",null,"Add video",r._buildUrlForm("video"))),-1!==a[1].indexOf("symbol",0)&&o.append(r._buildTollbarButton("insert","symbol","fa fa-hashtag",null,"Add symbol",r._buildSymbolsList())),-1!==a[1].indexOf("bookmark",0)&&o.append(r._buildTollbarButton("insert","bookmark","fa fa-bookmark",null,"Add bookmark"))):"special"===a[0]?(-1!==a[1].indexOf("print",0)&&o.append(r._buildTollbarButton("special","print","fa fa-print",null,"Print")),-1!==a[1].indexOf("clean",0)&&o.append(r._buildTollbarButton("special","clean","fa fa-eraser",null,"Erase style")),-1!==a[1].indexOf("visual",0)&&o.append(r._buildTollbarButton("special","visual","fa fa-solar-panel",null,"Visual blocks")),-1!==a[1].indexOf("unformat",0)&&o.append(r._buildTollbarButton("special","unformat","fa fa-trash-o fa-trash-alt",null,"Clear HTML"))):"fullscreen"===a[0]&&(o.addClass("pull-right"),o.append(r._buildTollbarButton("fullscreen",!0,"fa fa-arrows-alt",null,"Fullscreen mode")));r._$toolbar.append(o)})),r._$toolbar.length&&r._$toolbar.on("click","[data-action]",(function(t){var a=e(t.currentTarget),o=a.data("action"),n=(r._selection,a.data("value")),l=a.data();if(void 0!==o&&void 0!==n)switch(r._config.debug&&console.log("Switch action: `"+o+"` with value: `"+n+"`"),o){case"mode":switch(n){case"editor":r._config.mode!==n&&(r._config.mode=n,r._$content.html(r._source),r._$toolbar.find('[data-action="mode"]').removeClass("active"),r._$toolbar.find('[data-action="mode"][data-value="editor"]').addClass("active"),r._$content.addClass("editor-mode").removeClass("source-mode"),r._$content.focus()),r._$toolbar.find(".btn-group").removeClass("hide");break;case"source":if(r._$toolbar.find(".btn-group").not("#toolbarGroup-"+o).addClass("hide"),r._config.mode!==n){r._config.mode=n,r._source=r._$content.html();var i=e("<pre />");i.text(r._source),r._$content.html(r._trimSource(i.html())),r._config.highlight&&(hljs.initHighlighting.called=!1,hljs.configure({useBR:!0,languages:["html","javascript","css"]}),hljs.highlightBlock(r._$content.get(0))),r._$toolbar.find('[data-action="mode"]').removeClass("active"),r._$toolbar.find('[data-action="mode"][data-value="source"]').addClass("active"),r._$content.removeClass("editor-mode").addClass("source-mode"),r._$content.focus()}}break;case"formatblock":r._formatDoc("formatblock",n);break;case"fontname":r._formatDoc("fontname",n);break;case"fontsize":r._selection.anchorNode.parentElement.removeAttribute("size"),r._selection.anchorNode.parentElement.style.fontSize=n;break;case"style":var s=r._selection.anchorNode.parentElement.style.cssText;s?s+=n:s=n,r._selection.anchorNode.parentElement.removeAttribute("style"),r._selection.anchorNode.parentElement.style=s;break;case"fullscreen":r._config.debug&&console.log("Fire action: "+o+" with value: "+n+" is not supported.");break;case"operations":switch(n){case"undo":r._formatDoc("undo");break;case"rendo":r._formatDoc("rendo");break;case"cut":r._formatDoc("cut");break;case"copy":r._formatDoc("copy");break;case"paste":r._formatDoc("paste")}break;case"text":switch(n){case"bold":r._formatDoc("bold");break;case"italic":r._formatDoc("italic");break;case"underline":r._formatDoc("underline");break;case"strike":r._formatDoc("strikeThrough");break;case"subscript":r._formatDoc("subscript");break;case"superscript":r._formatDoc("superscript")}break;case"font-color":"unset"==n?(r._selection.anchorNode&&(r._selection.anchorNode.parentElement.style.backgroundColor=""),r._selection.anchorNode.parentElement.style.length&&r._selection.anchorNode.parentElement.removeAttribute("style")):(r._$toolbar.find('[data-action="text"][data-value="font-color"] > span').css("border-bottom-color",n),r._formatDoc("foreColor",n));break;case"bg-color":"unset"==n?(r._selection.anchorNode&&(r._selection.anchorNode.parentElement.style.backgroundColor=""),r._selection.anchorNode.parentElement.style.length&&r._selection.anchorNode.parentElement.removeAttribute("style")):(r._$toolbar.find('[data-action="text"][data-value="bg-color"] > span').css("border-bottom-color",n),r._formatDoc("hiliteColor",n));break;case"align":switch(n){case"left":r._formatDoc("justifyLeft");break;case"center":r._formatDoc("justifyCenter");break;case"right":r._formatDoc("justifyRight");break;case"justify":r._formatDoc("justifyFull")}break;case"lists":switch(n){case"unordered":r._formatDoc("insertUnorderedList");break;case"ordered":r._formatDoc("insertOrderedList");break;case"indent":r._formatDoc("indent");break;case"outdent":r._formatDoc("outdent")}break;case"insert-table":if(r._selection.anchorNode){var d=n.split("|",2),c=e(r._selection.anchorNode.parentElement),u=r._generateTable(parseFloat(d[0]),parseFloat(d[2]));c.after(u)}break;case"components":switch(n){case"chart":r._config.debug&&console.log("Fire action: "+o+" with value: "+n+" is not supported.")}break;case"line-height":if(r._selection.anchorNode){var p=100*parseFloat(n)+"%";0==parseFloat(n)?r._selection.anchorNode.parentElement.style.lineHeight="inherit":r._selection.anchorNode.parentElement.style.lineHeight=p}break;case"letter-spacing":if(r._selection.anchorNode){var f=parseFloat(n)+"px";0==parseFloat(n)?r._selection.anchorNode.parentElement.style.letterSpacing="inherit":r._selection.anchorNode.parentElement.style.letterSpacing=f}break;case"add-url":var b=r._selection.toString();if(r._selection&&b){var g=n;console.log(l),l.scheme&&("https"==l.scheme?g="https://"+g:"http"==l.scheme?g="http://"+g:"mailto"==l.scheme?g="mailto://"+g:"ftp"==l.scheme?g="ftp://"+g:"feed"==l.scheme?g="feed://"+g:"news"==l.scheme?g="news://"+g:"tel"==l.scheme?g="tel:"+g:"skype"==l.scheme?g="skype:"+g:"tg"==l.scheme?g="tg://"+g:"whatsapp"==l.scheme?g="whatsapp:"+g:"viber"==l.scheme&&(g="viber:"+g));var v="";l.title&&(v=' title="'+l.title+'"');var m="";l.class&&(m=' class="'+l.class+'"');var h="";l.target&&("blank"==l.target?h=' target="_blank"':"top"==l.target?h=' target="_top"':"self"==l.target?h=' target="_self"':"parent"==l.target&&(h=' target="_parent"'));var _="";l.relation&&("nofollow"==l.relation?_=' rel="nofollow"':"noreferrer"==l.relation&&(_=' rel="noreferrer"'));var y=e('<a href="'+g+'"'+v+m+h+_+" />");y.text(b),($=r._selection.getRangeAt(0)).deleteContents(),$.insertNode(y.get(0))}break;case"add-video":if(r._selection&&n){g=n;if(l.service)if("youtube"==l.service){var x=null,w=/^.*(youtube\/|youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;null!==(k=g.match(w))&&11==k[2].length&&(x=k[2]),x&&(g="https://www.youtube.com/embed/"+x)}else if("vimeo"==l.service){x=null,w=/(?:www\.|player\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/(?:[^\/]*)\/videos\/|album\/(?:\d+)\/video\/|video\/|)(\d+)(?:[a-zA-Z0-9_\-]+)?/i;null!==(k=g.match(w))&&9==k[1].length&&(x=k[1]),x&&(g="https://player.vimeo.com/video/"+k[1])}else if("dailymotion"==l.service){var k;x=null,w=/^.+dailymotion.com\/(video|hub)\/([^_]+)[^#]*(#video=([^_&]+))?/;null!==(k=g.match(w))&&(void 0!==k[4]&&(x=k[4]),x=k[2]),x&&(g="https://www.dailymotion.com/embed/video/"+x)}var C=e('<div class="embed-responsive embed-responsive-16by9"><iframe class="embed-responsive-item" src="'+g+'"></iframe></div>');($=r._selection.getRangeAt(0)).deleteContents(),$.insertNode(C.get(0))}break;case"add-image":if(r._selection&&n){var $,T=e('<img src="'+n+'" />');($=r._selection.getRangeAt(0)).deleteContents(),$.insertNode(T.get(0))}break;case"insert-html":r._formatDoc("insertHTML",n);break;case"special":switch(n){case"print":r._printDoc();break;case"clean":r._formatDoc("removeFormat");break;case"visual":r._$content.hasClass("visual")?(r._$toolbar.find('[data-action="special"][data-value="visual"]').removeClass("active"),r._$content.removeClass("visual"),r._$content.focus()):(r._$toolbar.find('[data-action="special"][data-value="visual"]').addClass("active"),r._$content.addClass("visual"),r._$content.focus());break;case"unformat":r._formatDoc("selectAll"),r._formatDoc("removeFormat");var S=r._$content.html();S=(S=(S=r._stripTags(S)).replace(/(\r\n|\n|\r)/g,"\x3c!-- br --\x3e")).replace(/<!-- br -->/g,"<br/>"),r._$content.html(S)}break;default:r._config.debug&&console.warn("Unrecognized action: "+o+" with value: "+n)}})),r._$content.on("mouseup click focus",(function(t){const a=e(this);if(r._popoverIsVisible&&r._hideAllPopovers(),"text"!==t.target.type&&(r._selection=document.getSelection()),r._selection.getRangeAt&&r._selection.rangeCount)if(r._selection.parentNode){var o=e(r._selection.parentNode);r._updateState(o)}else if(r._selection.parentElement){o=e(r._selection.parentElement);r._updateState(o)}r._config.debug&&console.log("Current selection: ",r._selection);o=e(t.target);r._updateState(o),a.trigger("change")})),r._$content.on("keydown",(function(t){const a=e(this);if(r._popoverIsVisible&&r._hideAllPopovers(),"text"!==t.target.type&&(r._selection=document.getSelection()),r._selection.getRangeAt&&r._selection.rangeCount)if(r._selection.parentNode){var o=e(r._selection.parentNode);r._updateState(o)}else if(r._selection.parentElement){o=e(r._selection.parentElement);r._updateState(o)}o=e(t.target);r._updateState(o),a.trigger("change"),r._config.debug&&console.log("Keydown fired: "+t.keyCode)})),r._$content.on("change",(function(t){const a=e(this);setTimeout((function(){"editor"==r._config.mode?r._source=a.html():r._source=a.text(),e(r._$element).is("textarea")?r._$element.html(r._source):r._$element.val(r._source),r._config.debug&&console.log("Content change...")}),200)})),r._$content.on("blur",(function(){const t=e(this);r._$lastFocus=this,r._selection=document.getSelection(),t.trigger("change"),r._config.debug&&console.log("Content lost focus: ",r._selection)})),r._$content.focus()}return t(o,{element:{value:function(){return this._$element}},_replaceAll:{value:function(e,t,a){return a.split(e).join(t)}},_stripTags:{value:function(e,t){var a,o=[];t&&(o=t.match(/([a-zA-Z]+)/gi)),"string"!=typeof e&&(e=e.toString());var n=e.match(/(<\/?[\S][^>]*>)/gi);for(a in n)if(!isNaN(a)){var l=n[a].toString(),r=!1;for(a in o){var i=o[a],s=l.toLowerCase().indexOf("<"+i+">");if(0!=s&&(s=l.toLowerCase().indexOf("<"+i+" ")),0!=s&&(s=l.toLowerCase().indexOf("</"+i)),0==s){r=!0;break}}r||(e=this._replaceAll(l,"",e))}return e}},_trimSource:{value:function(e){return e=(e=(e=e.replace(/\s{4,}/g,"")).replace(/\t/g," ")).toString().trim().replace(/(\r\n|\n|\r)/g,"")}},_getPath:{value:function(t,a,o){for(var n,l=[];t.length&&!t[0].isEqualNode(a[0]);){var r=t[0],i=r.localName,s=t.parentsUntil(a);if(!i)break;if(i=i.toLowerCase(),o&&s.children(i).length>1){var d=s.children().index(r)+1;d>1&&(i+=":nth-child("+d+")")}l.push(i);var c=e(r).attr("id");c&&(i+="#"+c);var u=e(r).attr("class");u&&(i+="."+u.replace(/\./g,".")),n=i+(n?" > "+n:""),t=s}return{path:n,tags:l}}},_getTextStat:{value:function(e){var t;return t=e&&e.contentEditable?e.innerText.replace(/\r\n/g,"\n"):e.value.replace(/\r\n/g,"\n"),{words:this._stripTags(t).split(" ").length,length:t.length,chars:this._trimSource(t.replace(/\s/g,"")).length}}},_getTextPosition:{value:function(e){var t,a,o,n,l,r=0,i=0,s=0,d=e&&e.contentEditable;return"selectionStart"in e&&document.activeElement==e?(i=e.selectionStart,s=e.selectionEnd,r=(t=e.value.replace(/\r\n/g,"\n")).substr(0,e.selectionStart).split("\n").length):d?(i=window.getSelection().getRangeAt(0).startOffset,s=window.getSelection().getRangeAt(0).endOffset,0==(r=(t=e.innerText.replace(/\r\n/g,"\n")).substr(0,e.selectionStart).split("\n").length-1)&&(r=1)):(a=this._selection.createRange())&&a.parentElement()==e&&(n=e.value.length,t=e.value.replace(/\r\n/g,"\n"),(o=e.createTextRange()).moveToBookmark(a.getBookmark()),(l=e.createTextRange()).collapse(!1),o.compareEndPoints("StartToEnd",l)>-1?i=s=n:(i=-o.moveStart("character",-n),i+=t.slice(0,i).split("\n").length-1,o.compareEndPoints("EndToEnd",l)>-1?s=n:(s=-o.moveEnd("character",-n),s+=t.slice(0,s).split("\n").length-1))),{line:r,start:i,end:s,selected:this._selection.toString().length}}},_formatDoc:{value:function(e,t){document.execCommand(e,!1,t),this._$content.focus()}},_printDoc:{value:function(){var e=window.open("","_blank","width=450,height=470,left=400,top=100,menubar=yes,toolbar=no,location=no,scrollbars=yes");e.document.open(),e.document.write('<!doctype html><html><head><title>Print</title></head><body onload="print();">'+this._$content.get(0).innerHTML+"</body></html>"),e.document.close()}},_hideAllPopovers:{value:function(){this._$toolbar.find(".popover").each((function(){e(this).popover("hide")})),this._popoverIsVisible=!1}},_detectLanguage:{value:function(){return(navigator.languages&&navigator.languages.length?navigator.languages[0]:navigator.userLanguage||navigator.language||navigator.browserLanguage||"en").toLowerCase()}},_translate:{value:function(e){var t=this,a=t._config.language;return void 0===a&&(a=t._detectLanguage()),t._config.translations.hasOwnProperty(a)&&t._config.translations[a][e.toString()]&&(e=t._config.translations[a][e.toString()]),e.toLocaleString()}},_buildTollbarButton:{value:function(t,a,o,n,l,r){var i=this,s=(i._selection,e('<button type="button" class="btn btn-default" tabindex="-1" />'));return t&&s.attr("data-action",t),a&&s.attr("data-value",a),n&&s.attr("data-hotkey",n),l&&s.tooltip({html:!0,placement:"top",container:"body",title:i._translate(l.toString().trim())}),r?s.popover({html:!0,trigger:"manual",viewport:"body",placement:"bottom",content:function(){return"object"==typeof r?r:e(r)}}).on("shown.bs.popover",(function(t){var a=e(t.target).attr("aria-describedby"),o=i._$toolbar.find("#"+a),n=i._selection,l=n.getRangeAt(0);n&&l&&o.find("input").on("blur",(function(e){return"text"==e.target.type&&i._$lastFocus&&setTimeout((function(){i._$lastFocus.focus(),i._selectText(n,l)}),50),!1})),o.on("click",(function(t){t.preventDefault(),i._config.debug&&(console.log("Popover event target type: "+t.target.type),console.log("Popover event target tag: "+t.target.tagName)),(t.target.type||"a"==t.target.tagName.toLowerCase())&&e(t.target).get(0).hasAttribute("data-action")&&o.popover("hide")})),o.find(".table-grid").length&&o.find(".table-grid tr > td").hover((function(){e(this).addClass("selected"),e(this).prevAll().addClass("selected"),e(this).parent().prevAll().find("td:lt("+(e(this).index()+1)+")").addClass("selected")}),(function(){e(this).removeClass("selected"),e(this).prevAll().removeClass("selected"),e(this).parent().prevAll().find("td:lt("+(e(this).index()+1)+")").removeClass("selected")}))})).on("click",(function(e){i._config.debug&&(console.log("Element event target type: "+e.target.type),console.log("Element event target tag: "+e.target.tagName)),e.preventDefault(),e.stopPropagation(),i._popoverIsVisible&&i._hideAllPopovers(),s.popover("show"),i._popoverIsVisible=!0})):s.on("click",(function(e){e.preventDefault(),i._hideAllPopovers()})),o&&s.append('<span class="'+o+'" />'),s}},_buildTollbarDropdown:{value:function(t,a,o,n){var l=e('<div class="dropdown" />'),r=e('<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" />'),i=e('<ul class="dropdown-menu" />'),s=e("<li />"),d=e('<a href="#" tabindex="-1" />');return"object"==typeof a&&e.each(a,(function(a,n){var l=d.clone(),r=s.clone();"object"==typeof n?(n.action&&l.attr("data-action",n.action),n.value&&l.attr("data-value",n.value),n.wrap?l.html(e(n.wrap).text(a)):l.text(a),n.style&&l.attr("style",n.style.toString()),a==o&&r.addClass("active"),r.append(l),i.append(r)):(l.text(n),l.attr("data-action",t),l.attr("data-value",n),n==o&&r.addClass("active"),r.append(l),i.append(r)),l.on("click",(function(e){e.preventDefault()}))})),o?r.text(o+" "):r.text("Dropdown "),r.append('<b class="caret" />'),n&&r.tooltip({html:!0,placement:"top",title:this._translate(n.toString().trim())}),l.append(r),l.append(i),l}},_buildColorPalette:{value:function(t,a,o){var n="";return e.each(t,(function(t,o){n+='<table class="color-palette"><tr>',e.each(o,(function(e,t){n+='<td><a href="#" data-action="'+a+'" data-value="'+t+'" style="background-color: '+t+'">&nbsp;</a></td>',n+=(parseInt(e)+1)%10?"":"</tr>",n+=(parseInt(e)+1)%10?"":"<tr>"})),n+="</tr></table>"})),o&&(n+='<p><a href="#" class="btn btn-sm btn-block" data-action="'+a+'" data-value="unset">Reset color</a></p>'),n}},_buildTableGrid:{value:function(){for(var e='<table class="table-grid">',t=1;t<=6;t++){e+="<tr>";for(var a=1;a<=8;a++)e+='<td><a href="#" data-action="insert-table" data-value="'+t+"|"+a+'">&nbsp;</a></td>';e+="</tr>"}return e+="</table>"}},_buildLetterSpacingList:{value:function(){return'<ul class="nav nav-pills nav-stacked">\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="-5">-5</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="-3">-3</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="-2">-2</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="-1">-1</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="0">0</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="1">1</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="2">2</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="3">3</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="5">5</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="8">8</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="10">10</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="12">12</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="15">15</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="25">25</a></li>\n  <li role="presentation"><a href="#" data-action="letter-spacing" data-value="50">50</a></li>\n</ul>'}},_buildLineHeightList:{value:function(){return'<ul class="nav nav-pills nav-stacked">\n  <li role="presentation"><a href="#" data-action="line-height" data-value="0.5">0.5</a></li>\n  <li role="presentation"><a href="#" data-action="line-height" data-value="1.0">1.0</a></li>\n  <li role="presentation"><a href="#" data-action="line-height" data-value="1.15">1.15</a></li>\n  <li role="presentation"><a href="#" data-action="line-height" data-value="1.5">1.5</a></li>\n  <li role="presentation"><a href="#" data-action="line-height" data-value="2.0">2.0</a></li>\n</ul>'}},_selectText:{value:function(e,t){e||(e=document.getSelection()),t||(t=e.getRangeAt(0)),e.removeAllRanges(),e.addRange(t)}},_buildEmojiList:{value:function(){var e=this._config.emojiDefault;if(e.length>0){for(var t=Math.round(e.length/8)+1,a='<table class="emojis-list">',o=1,n=0;o<=t;o++){a+="<tr>";for(var l=1;l<=8&&n!=e.length;l++)a+='<td><a href="#" data-action="insert-html" data-value="'+e[n].toString()+'">'+e[n]+"</a></td>",n++;a+="</tr>"}return a+="</table>"}return!1}},_buildSymbolsList:{value:function(){var e=this._config.symbolsDefault;if(e.length>0){for(var t=Math.round(e.length/10),a='<table class="symbols-list">',o=1,n=0;o<=t;o++){a+="<tr>";for(var l=1;l<=10&&n!=e.length;l++)a+='<td><a href="#" data-action="insert-html" data-value="'+e[n]+'" style="min-width:16px;text-align:center;">'+e[n]+"</a></td>",n++;a+="</tr>"}return a+="</table>"}return!1}},_buildDdropdown:{value:function(t,a,o,n,l,r){null==a&&(a="Not set"),null==o&&(o='<span class="caret"></span>'),null==n&&(o={}),null==r&&(r="data-value");var i=e('<div class="dropdown" />'),s=e('<button type="button" class="btn btn-block btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" />');s.attr("id",t),s.html(a+" "+o);var d=e('<ul class="dropdown-menu" aria-labelledby="'+t+'" />');l||d.append('<li class="active"><a href="#">'+a+"</a></li>");for(let[e,t]of Object.entries(n))"separator"==e.toString()?d.append('<li role="separator" class="divider"></li>'):l==e.toString()?d.append('<li class="active"><a href="#" '+r+'="'+e+'">'+t+"</a></li>"):d.append('<li><a href="#" '+r+'="'+e+'">'+t+"</a></li>");return d.find("li").on("click",(function(t){d.find("li").removeClass("active"),e(this).addClass("active"),s.html(e(this).text()+" "+o)})),i.append(s),i.append(d),i}},_buildUrlForm:{value:function(t){var a=this;this._config.debug&&console.log("Build URL form for type: "+t);var o=e('<form class="form-horizontal" />'),n=e('<div class="form-group" />'),l=e('<div class="col-xs-12 col-sm-12" />'),c=e('<div class="input-group input-group-sm" />'),u=e('<div class="dropdown" />');e('<button type="button" class="btn btn-block btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" />');if("image"==t)c.append('<span class="input-group-addon">Image:</span>');else if("video"==t){(u=a._buildDdropdown("videoServices","YouTube",null,r,"youtube","data-service")).attr("class","input-group-btn"),u.find('.btn[data-toggle="dropdown"]').toggleClass("btn-default","btn-secondary"),c.append(u)}else if("link"==t){(u=a._buildDdropdown("urlSchemes","https://",null,i,"https","data-scheme")).attr("class","input-group-btn"),u.find('.btn[data-toggle="dropdown"]').toggleClass("btn-default","btn-secondary"),c.append(u)}var p=e('<input type="text" class="form-control" placeholder="Type your URL..." />');"image"==t?p.attr("id","imageUrl"):"video"==t?p.attr("id","videoUrl"):"link"==t&&p.attr("id","urlInput"),c.append(p);var f=e('<span class="input-group-btn" />'),b=e('<button type="button" class="btn btn-block btn-primary">Add</button>');if("image"==t?b.attr("data-action","add-image"):"video"==t?b.attr("data-action","add-video"):b.attr("data-action","add-url"),b.on("click",(function(t){var a=e(t.target).data("action");if(e(t.target).data("value",p.val()),"add-url"==a){var n=o.find('[aria-labelledby="urlSchemes"] li.active a[data-scheme]').first().data("scheme");e(t.target).data("scheme",n||null);var l=o.find("#urlTile").val();e(t.target).data("title",l||null);var r=o.find("#urlClass").val();e(t.target).data("class",r||null);var i=o.find('[aria-labelledby="urlLinkTarget"] li.active a[data-target]').first().data("target");e(t.target).data("target",i||null);var s=o.find('[aria-labelledby="urlLinkRel"] li.active a[data-rel]').first().data("rel");e(t.target).data("relation",s||null)}else if("add-video"==a){var d=o.find('[aria-labelledby="videoServices"] li.active a[data-service]').first().data("service");e(t.target).data("service",d||null)}console.log(b.data())})),f.append(b),c.append(f),l.append(c),n.append(l),o.append(n),"link"==t){'<div class="form-group form-group-sm">','    <div class="form-row">','        <label class="col-xs-12 col-sm-4">Tile:</label>','        <div class="col-xs-12 col-sm-8">','            <input type="text" class="form-control" id="urlTile" placeholder="Title of link..." />',"        </div>","    </div>","</div>",'<div class="form-group form-group-sm">','    <div class="form-row">','        <label class="col-xs-12 col-sm-4">Class:</label>','        <div class="col-xs-12 col-sm-8">','            <input type="text" class="form-control" id="urlClass" placeholder="CSS class name..." />',"        </div>","    </div>","</div>",o.append('<div class="form-group form-group-sm">    <div class="form-row">        <label class="col-xs-12 col-sm-4">Tile:</label>        <div class="col-xs-12 col-sm-8">            <input type="text" class="form-control" id="urlTile" placeholder="Title of link..." />        </div>    </div></div><div class="form-group form-group-sm">    <div class="form-row">        <label class="col-xs-12 col-sm-4">Class:</label>        <div class="col-xs-12 col-sm-8">            <input type="text" class="form-control" id="urlClass" placeholder="CSS class name..." />        </div>    </div></div>');n=e('<div class="form-group form-group-sm" />'),c=e('<div class="form-row input-group-sm" />');(g=e('<label class="col-xs-12 col-sm-4" />')).text("Target:"),c.append(g),(u=a._buildDdropdown("urlLinkTarget","Not set",null,s,null,"data-target")).addClass("col-xs-12 col-sm-8"),u.find('.btn[data-toggle="dropdown"]').addClass("btn-sm"),c.append(u),n.append(c),o.append(n);var g;n=e('<div class="form-group form-group-sm" />'),c=e('<div class="form-row input-group-sm" />');(g=e('<label class="col-xs-12 col-sm-4" />')).text("Relation:"),c.append(g),(u=a._buildDdropdown("urlLinkRel","Not set",null,d,null,"data-rel")).addClass("col-xs-12 col-sm-8"),u.find('.btn[data-toggle="dropdown"]').addClass("btn-sm"),c.append(u),n.append(c),o.append(n)}return o}},_generateTable:{value:function(e,t){e=parseInt(e)+1,(t=parseInt(e))||(t=1);for(var a='<table class="table">',o=1;o<=e;o++){1==o?a+="<thead>":o==e-o-1&&(a+="<tbody>"),a+="<tr>";for(var n=1;n<=t;n++)a+=1==o?"<th>Header "+n+"</th>":"<td>&nbsp;</td>";a+="</tr>",1==o?a+="</thead>":o==e&&(a+="</tbody>")}return a+="</table>"}},_updateState:{value:function(e,t){var a=this;if("editor"==a._config.mode){var o=a._getTextStat(a._$content.get(0)),n=a._getPath(e,a._$content,!1);if(t)a._$toolbar.find("button[data-action]").removeClass("active");else switch(n.tags[0]){case"b":a._$toolbar.find('[data-action="text"]').removeClass("active"),a._$toolbar.find('[data-action="text"][data-value="bold"]').addClass("active");break;case"u":a._$toolbar.find('[data-action="text"]').removeClass("active"),a._$toolbar.find('[data-action="text"][data-value="underline"]').addClass("active");break;case"sub":a._$toolbar.find('[data-action="text"]').removeClass("active"),a._$toolbar.find('[data-action="text"][data-value="subscript"]').addClass("active");break;case"sup":a._$toolbar.find('[data-action="text"]').removeClass("active"),a._$toolbar.find('[data-action="text"][data-value="superscript"]').addClass("active");break;case"i":a._$toolbar.find('[data-action="text"]').removeClass("active"),a._$toolbar.find('[data-action="text"][data-value="italic"]').addClass("active");break;case"a":a._$toolbar.find('[data-action="insert"]').removeClass("active"),a._$toolbar.find('[data-action="insert"][data-value="link"]').addClass("active");break;case"p":a._$toolbar.find('[data-action="align"]').removeClass("active"),"center"==e.css("text-align")?a._$toolbar.find('[data-action="align"][data-value="center"]').addClass("active"):"right"==e.css("text-align")?a._$toolbar.find('[data-action="align"][data-value="right"]').addClass("active"):"justify"==e.css("text-align")?a._$toolbar.find('[data-action="align"][data-value="justify"]').addClass("active"):a._$toolbar.find('[data-action="align"][data-value="left"]').addClass("active");break;default:a._$toolbar.find('[data-action="text"]').removeClass("active"),a._$toolbar.find('[data-action="align"]').removeClass("active"),a._$toolbar.find('[data-action="insert"]').removeClass("active")}a._$statusbar.path.text(n.path),a._$statusbar.stat.text("Length: "+o.length+", chars: "+o.chars+", words: "+o.words)}else{var l=a._getTextPosition(a._$content.get(0));a._$statusbar.path.empty(),parseInt(l.selected)>0?a._$statusbar.stat.text("Line: "+l.line+", column: "+l.end+", selected: "+l.selected):a._$statusbar.stat.text("Line: "+l.line+", column: "+l.end)}return a._$element}}},{Default:{get:function(){return n}},_jQueryInterface:{value:function(t){let n=this;if(/destroy|hide/.test(t=t||{})){let t=e(n);return t.removeClass("hide"),void t.parent(".wysiwyg-editor").replaceWith(t)}return n.each((function(){let l=e(n),r=e.extend({},a.Default,l.data(),"object"==typeof t&&t);new o(n,r)}))}}}),o}();return e.fn.wysiwyg=c._jQueryInterface,e.fn.wysiwyg.Constructor=c,e.fn.wysiwyg.noConflict=function(){return e.fn.wysiwyg=o,c._jQueryInterface},c}(jQuery)}(jQuery);